<?php
// Script para probar diferentes credenciales de base de datos
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>🔍 Test de Credenciales de Base de Datos</h1>";
echo "<style>body{font-family:Arial,sans-serif;margin:20px;} .ok{color:green;} .error{color:red;} .warning{color:orange;}</style>";

// Credenciales actuales
$credentials = [
    'current' => [
        'host' => 'localhost',
        'dbname' => 'v34sdfaas213_crmlead',
        'username' => 'v34sdfaas213_crmlead',
        'password' => '=?u_8W=IOU1^P@;X'
    ],
    'alternative1' => [
        'host' => 'localhost',
        'dbname' => 'crmlead',
        'username' => 'root',
        'password' => ''
    ],
    'alternative2' => [
        'host' => 'localhost',
        'dbname' => 'sistema200001',
        'username' => 'root',
        'password' => ''
    ]
];

foreach ($credentials as $name => $cred) {
    echo "<h2>Probando configuración: $name</h2>";
    echo "<p>Host: {$cred['host']}</p>";
    echo "<p>Database: {$cred['dbname']}</p>";
    echo "<p>Username: {$cred['username']}</p>";
    echo "<p>Password: " . (empty($cred['password']) ? '(vacía)' : '***') . "</p>";
    
    try {
        $dsn = "mysql:host={$cred['host']};dbname={$cred['dbname']};charset=utf8mb4";
        $pdo = new PDO($dsn, $cred['username'], $cred['password'], [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_TIMEOUT => 10
        ]);
        
        echo "<p class='ok'>✅ Conexión exitosa!</p>";
        
        // Verificar si existen las tablas necesarias
        $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
        echo "<p>Tablas encontradas: " . count($tables) . "</p>";
        
        $required_tables = ['usuarios', 'contactos'];
        foreach ($required_tables as $table) {
            if (in_array($table, $tables)) {
                echo "<p class='ok'>✅ Tabla '$table' existe</p>";
            } else {
                echo "<p class='error'>❌ Tabla '$table' no existe</p>";
            }
        }
        
        echo "<hr>";
        
    } catch (PDOException $e) {
        echo "<p class='error'>❌ Error de conexión: " . $e->getMessage() . "</p>";
        echo "<hr>";
    }
}

echo "<h2>Información del servidor MySQL</h2>";
try {
    // Intentar conexión básica sin especificar base de datos
    $pdo = new PDO("mysql:host=localhost", 'root', '', [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
    
    echo "<p class='ok'>✅ Servidor MySQL accesible</p>";
    
    // Listar todas las bases de datos
    $databases = $pdo->query("SHOW DATABASES")->fetchAll(PDO::FETCH_COLUMN);
    echo "<h3>Bases de datos disponibles:</h3>";
    foreach ($databases as $db) {
        echo "<p>📋 $db</p>";
    }
    
} catch (PDOException $e) {
    echo "<p class='error'>❌ No se puede conectar al servidor MySQL: " . $e->getMessage() . "</p>";
}
?>