<?php
// Test de conexión con las nuevas credenciales
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Prueba de Conexión a Base de Datos</h2>";

// Credenciales proporcionadas
$host = 'localhost';
$dbname = 'v34sdfaas213_crmlead';
$username = 'v34sdfaas213_crmlead';
$password = '=?u_8W=IOU1^P@;X';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "<p style='color: green;'>✅ Conexión exitosa a la base de datos</p>";
    echo "<p><strong>Host:</strong> $host</p>";
    echo "<p><strong>Base de datos:</strong> $dbname</p>";
    echo "<p><strong>Usuario:</strong> $username</p>";
    
    // Verificar si existen las tablas necesarias
    $stmt = $pdo->query("SHOW TABLES");
    $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    echo "<h3>Tablas encontradas:</h3>";
    if (empty($tables)) {
        echo "<p style='color: orange;'>⚠️ No se encontraron tablas en la base de datos</p>";
        echo "<p>Es posible que necesites ejecutar el archivo database.sql para crear las tablas</p>";
    } else {
        echo "<ul>";
        foreach ($tables as $table) {
            echo "<li>$table</li>";
        }
        echo "</ul>";
        
        // Verificar usuarios si existe la tabla
        if (in_array('usuarios', $tables)) {
            $stmt = $pdo->query("SELECT COUNT(*) as total FROM usuarios");
            $count = $stmt->fetch(PDO::FETCH_ASSOC);
            echo "<p><strong>Usuarios registrados:</strong> " . $count['total'] . "</p>";
        }
    }
    
    echo "<p style='color: blue;'>🎉 <strong>La conexión está funcionando correctamente!</strong></p>";
    echo "<p><a href='login.php' style='background: #dc2626; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;'>Probar Login</a></p>";
    
} catch(PDOException $e) {
    echo "<p style='color: red;'>❌ Error de conexión: " . $e->getMessage() . "</p>";
    
    // Sugerencias de solución
    echo "<h3>Posibles soluciones:</h3>";
    echo "<ul>";
    echo "<li>Verificar que el servidor MySQL esté ejecutándose</li>";
    echo "<li>Confirmar que la base de datos '$dbname' existe</li>";
    echo "<li>Verificar que el usuario '$username' tenga permisos</li>";
    echo "<li>Comprobar que la contraseña sea correcta</li>";
    echo "</ul>";
}
?>