<?php
// Script de debug para dashboard.php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Debug Dashboard - Diagnóstico de Errores</h2>";

try {
    echo "<p>1. Cargando config.php...</p>";
    require_once 'config.php';
    echo "<p style='color: green;'>✅ config.php cargado correctamente</p>";
    
    echo "<p>2. Cargando settings.php...</p>";
    require_once 'settings.php';
    echo "<p style='color: green;'>✅ settings.php cargado correctamente</p>";
    
    echo "<p>3. Verificando sesión...</p>";
    session_start();
    if (!isset($_SESSION['user_id'])) {
        echo "<p style='color: orange;'>⚠️ No hay sesión activa - simulando login</p>";
        // Simular sesión para debug
        $_SESSION['user_id'] = 1;
        $_SESSION['user_name'] = 'test';
        $_SESSION['user_email'] = 'test@test.com';
        $_SESSION['user_type'] = 'usuario';
    } else {
        echo "<p style='color: green;'>✅ Sesión activa encontrada</p>";
    }
    
    echo "<p>4. Probando conexión a base de datos...</p>";
    $database = new Database();
    $db = $database->getConnection();
    echo "<p style='color: green;'>✅ Conexión a base de datos exitosa</p>";
    
    echo "<p>5. Verificando tablas necesarias...</p>";
    $tables = ['usuarios', 'contactos'];
    foreach ($tables as $table) {
        $stmt = $db->query("SHOW TABLES LIKE '$table'");
        if ($stmt->rowCount() > 0) {
            echo "<p style='color: green;'>✅ Tabla '$table' existe</p>";
        } else {
            echo "<p style='color: red;'>❌ Tabla '$table' NO existe</p>";
        }
    }
    
    echo "<p>6. Probando consultas de estadísticas...</p>";
    
    // Probar consulta de total de contactos
    $query_total = "SELECT COUNT(*) as total FROM contactos WHERE usuario_id = :user_id";
    $stmt_total = $db->prepare($query_total);
    $stmt_total->bindParam(':user_id', $_SESSION['user_id']);
    $stmt_total->execute();
    $total_contactos = $stmt_total->fetch()['total'];
    echo "<p style='color: green;'>✅ Total contactos: $total_contactos</p>";
    
    echo "<p>7. Probando configuración del sistema...</p>";
    $systemSettings = getSystemSettings();
    echo "<p style='color: green;'>✅ Configuración del sistema cargada</p>";
    echo "<pre>" . print_r($systemSettings, true) . "</pre>";
    
    echo "<p style='color: blue;'>🎉 <strong>Todas las pruebas pasaron correctamente!</strong></p>";
    echo "<p>El dashboard debería funcionar ahora. <a href='dashboard.php'>Probar Dashboard</a></p>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Error encontrado: " . $e->getMessage() . "</p>";
    echo "<p><strong>Archivo:</strong> " . $e->getFile() . "</p>";
    echo "<p><strong>Línea:</strong> " . $e->getLine() . "</p>";
    echo "<p><strong>Stack trace:</strong></p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}
?>