<?php
require_once 'config.php';

// Inicializar conexión a la base de datos
$database = new Database();
$db = $database->getConnection();

echo "<!DOCTYPE html>";
echo "<html lang='es'>";
echo "<head>";
echo "<meta charset='UTF-8'>";
echo "<meta name='viewport' content='width=device-width, initial-scale=1.0'>";
echo "<title>Verificación de Usuarios - CRM</title>";
echo "<link href='https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css' rel='stylesheet'>";
echo "<link href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css' rel='stylesheet'>";
echo "</head>";
echo "<body class='bg-light'>";
echo "<div class='container mt-5'>";
echo "<div class='row justify-content-center'>";
echo "<div class='col-md-8'>";
echo "<div class='card shadow'>";
echo "<div class='card-header bg-primary text-white'>";
echo "<h4><i class='fas fa-users'></i> Verificación y Reparación de Usuarios</h4>";
echo "</div>";
echo "<div class='card-body'>";

try {
    // Verificar si existe la tabla usuarios
    $stmt = $db->query("SHOW TABLES LIKE 'usuarios'");
    if ($stmt->rowCount() == 0) {
        echo "<div class='alert alert-danger'>";
        echo "<h5><i class='fas fa-exclamation-triangle'></i> Error Crítico</h5>";
        echo "<p>La tabla 'usuarios' no existe en la base de datos.</p>";
        echo "<p><strong>Solución:</strong> Ejecute el archivo <code>database.sql</code> en su base de datos.</p>";
        echo "</div>";
    } else {
        echo "<div class='alert alert-success'>";
        echo "<i class='fas fa-check'></i> La tabla 'usuarios' existe correctamente.";
        echo "</div>";
        
        // Obtener todos los usuarios
        $stmt = $db->query("SELECT id, username, email, tipo, activo FROM usuarios ORDER BY id");
        $usuarios = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo "<h5><i class='fas fa-list'></i> Usuarios en la base de datos:</h5>";
        
        if (empty($usuarios)) {
            echo "<div class='alert alert-warning'>";
            echo "<h6><i class='fas fa-exclamation-circle'></i> No hay usuarios registrados</h6>";
            echo "<p>La tabla usuarios está vacía. Esto puede causar errores al agregar contactos.</p>";
            echo "<p><strong>Solución:</strong> Crear un usuario administrador.</p>";
            echo "</div>";
            
            // Crear usuario administrador automáticamente
            $password_hash = password_hash('admin123', PASSWORD_DEFAULT);
            $stmt = $db->prepare("INSERT INTO usuarios (username, email, password, tipo) VALUES (?, ?, ?, ?)");
            $stmt->execute(['Administrador', 'admin@crm.com', $password_hash, 'administrador']);
            
            echo "<div class='alert alert-success'>";
            echo "<h6><i class='fas fa-user-plus'></i> Usuario administrador creado</h6>";
            echo "<p><strong>Email:</strong> admin@crm.com</p>";
            echo "<p><strong>Contraseña:</strong> admin123</p>";
            echo "<p class='mb-0'>Ya puede usar el sistema normalmente.</p>";
            echo "</div>";
            
        } else {
            echo "<div class='table-responsive'>";
            echo "<table class='table table-striped'>";
            echo "<thead class='table-dark'>";
            echo "<tr><th>ID</th><th>Username</th><th>Email</th><th>Tipo</th><th>Estado</th></tr>";
            echo "</thead>";
            echo "<tbody>";
            
            foreach ($usuarios as $usuario) {
                $badge_tipo = $usuario['tipo'] == 'administrador' ? 'bg-danger' : 'bg-primary';
                $badge_estado = $usuario['activo'] ? 'bg-success' : 'bg-secondary';
                $estado_texto = $usuario['activo'] ? 'Activo' : 'Inactivo';
                
                echo "<tr>";
                echo "<td><strong>" . $usuario['id'] . "</strong></td>";
                echo "<td>" . htmlspecialchars($usuario['username']) . "</td>";
                echo "<td>" . htmlspecialchars($usuario['email']) . "</td>";
                echo "<td><span class='badge {$badge_tipo}'>" . ucfirst($usuario['tipo']) . "</span></td>";
                echo "<td><span class='badge {$badge_estado}'>{$estado_texto}</span></td>";
                echo "</tr>";
            }
            
            echo "</tbody>";
            echo "</table>";
            echo "</div>";
            
            echo "<div class='alert alert-info'>";
            echo "<h6><i class='fas fa-info-circle'></i> Estado del sistema</h6>";
            echo "<p>Se encontraron <strong>" . count($usuarios) . " usuarios</strong> en la base de datos.</p>";
            echo "<p class='mb-0'>El sistema debería funcionar correctamente.</p>";
            echo "</div>";
        }
        
        // Verificar sesión actual
        echo "<h5><i class='fas fa-user-check'></i> Verificación de sesión actual:</h5>";
        
        if (isset($_SESSION['user_id'])) {
            $stmt = $db->prepare("SELECT username, email FROM usuarios WHERE id = ?");
            $stmt->execute([$_SESSION['user_id']]);
            $usuario_actual = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($usuario_actual) {
                echo "<div class='alert alert-success'>";
                echo "<h6><i class='fas fa-check-circle'></i> Sesión válida</h6>";
                echo "<p><strong>Usuario actual:</strong> " . htmlspecialchars($usuario_actual['username']) . "</p>";
                echo "<p><strong>Email:</strong> " . htmlspecialchars($usuario_actual['email']) . "</p>";
                echo "<p><strong>ID de sesión:</strong> " . $_SESSION['user_id'] . "</p>";
                echo "</div>";
            } else {
                echo "<div class='alert alert-danger'>";
                echo "<h6><i class='fas fa-exclamation-triangle'></i> Sesión inválida</h6>";
                echo "<p>El ID de usuario en la sesión (" . $_SESSION['user_id'] . ") no existe en la base de datos.</p>";
                echo "<p><strong>Solución:</strong> Cerrar sesión e iniciar sesión nuevamente.</p>";
                echo "</div>";
            }
        } else {
            echo "<div class='alert alert-warning'>";
            echo "<h6><i class='fas fa-sign-in-alt'></i> No hay sesión activa</h6>";
            echo "<p>No hay ningún usuario logueado actualmente.</p>";
            echo "</div>";
        }
    }
    
} catch (Exception $e) {
    echo "<div class='alert alert-danger'>";
    echo "<h5><i class='fas fa-exclamation-triangle'></i> Error de conexión</h5>";
    echo "<p><strong>Error:</strong> " . htmlspecialchars($e->getMessage()) . "</p>";
    echo "<p>Verifique la configuración de la base de datos en <code>config.php</code></p>";
    echo "</div>";
}

echo "</div>";
echo "<div class='card-footer text-center'>";
echo "<a href='contactos.php' class='btn btn-primary me-2'><i class='fas fa-arrow-left'></i> Volver a Contactos</a>";
echo "<a href='login.php' class='btn btn-secondary me-2'><i class='fas fa-sign-in-alt'></i> Iniciar Sesión</a>";
echo "<a href='logout.php' class='btn btn-warning'><i class='fas fa-sign-out-alt'></i> Cerrar Sesión</a>";
echo "</div>";
echo "</div>";
echo "</div>";
echo "</div>";
echo "</div>";
echo "</body>";
echo "</html>";
?>