<?php

// Autoloader simple para PhpSpreadsheet y PSR interfaces
spl_autoload_register(function ($class) {
    // Manejar interfaces PSR\SimpleCache
    if (strpos($class, 'Psr\\SimpleCache\\') === 0) {
        $file = __DIR__ . '/psr/simple-cache/src/' . str_replace('Psr\\SimpleCache\\', '', $class) . '.php';
        if (file_exists($file)) {
            require_once $file;
            return true;
        }
    }
    
    // Manejar clases PhpSpreadsheet
    if (strpos($class, 'PhpOffice\\PhpSpreadsheet\\') === 0) {
        $file = __DIR__ . '/phpoffice/phpspreadsheet/src/' . str_replace('PhpOffice\\', '', str_replace('\\', '/', $class)) . '.php';
        if (file_exists($file)) {
            require_once $file;
            return true;
        }
    }
    
    return false;
});

// Cargar interfaces PSR primero
require_once __DIR__ . '/psr/simple-cache/src/CacheException.php';
require_once __DIR__ . '/psr/simple-cache/src/InvalidArgumentException.php';
require_once __DIR__ . '/psr/simple-cache/src/CacheInterface.php';

// Cargar las clases principales de PhpSpreadsheet
require_once __DIR__ . '/phpoffice/phpspreadsheet/src/PhpSpreadsheet/Spreadsheet.php';
require_once __DIR__ . '/phpoffice/phpspreadsheet/src/PhpSpreadsheet/IOFactory.php';
require_once __DIR__ . '/phpoffice/phpspreadsheet/src/PhpSpreadsheet/Reader/IReader.php';
require_once __DIR__ . '/phpoffice/phpspreadsheet/src/PhpSpreadsheet/Reader/BaseReader.php';
require_once __DIR__ . '/phpoffice/phpspreadsheet/src/PhpSpreadsheet/Reader/Xlsx.php';
require_once __DIR__ . '/phpoffice/phpspreadsheet/src/PhpSpreadsheet/Reader/Xls.php';
require_once __DIR__ . '/phpoffice/phpspreadsheet/src/PhpSpreadsheet/Worksheet/Worksheet.php';
require_once __DIR__ . '/phpoffice/phpspreadsheet/src/PhpSpreadsheet/Cell/Cell.php';
require_once __DIR__ . '/phpoffice/phpspreadsheet/src/PhpSpreadsheet/Shared/Date.php';