<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Verificar si el usuario está logueado
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Obtener la página actual para marcar el enlace activo
$current_page = basename($_SERVER['PHP_SELF']);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #dc2626;
            --secondary-color: #b91c1c;
            --accent-color: #f87171;
            --success-color: #10b981;
            --warning-color: #f59e0b;
            --danger-color: #ef4444;
            --dark-color: #1f2937;
            --light-color: #f8fafc;
            --border-color: #e5e7eb;
            --text-primary: #111827;
            --text-secondary: #6b7280;
            --header-height: 70px;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            color: var(--text-primary);
            min-height: 100vh;
            padding-top: var(--header-height);
        }
        
        .top-header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 0 2rem;
            height: var(--header-height);
            display: flex;
            align-items: center;
            justify-content: space-between;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
            z-index: 1000;
        }
        
        .logo-container {
            display: flex;
            align-items: center;
            gap: 1rem;
        }
        
        .logo-container img {
            width: 40px;
            height: 40px;
            border-radius: 8px;
        }
        
        .logo-container h4 {
            margin: 0;
            font-weight: 600;
            font-size: 1.2rem;
        }
        
        .nav-menu {
            display: flex;
            gap: 2rem;
            align-items: center;
        }
        
        .nav-menu a {
            color: white;
            text-decoration: none;
            padding: 0.75rem 1.5rem;
            border-radius: 12px;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            font-weight: 500;
        }
        
        .nav-menu a:hover,
        .nav-menu a.active {
            background: rgba(255, 255, 255, 0.2);
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        }
        
        .user-dropdown {
            position: relative;
        }
        
        .user-dropdown button {
            background: rgba(255, 255, 255, 0.15);
            border: none;
            color: white;
            padding: 0.75rem 1.5rem;
            border-radius: 12px;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 0.75rem;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        .user-dropdown:hover button {
            background: rgba(255, 255, 255, 0.25);
            transform: translateY(-2px);
        }
        
        .dropdown-menu {
            position: absolute;
            top: 100%;
            right: 0;
            background: white;
            border-radius: 8px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
            min-width: 200px;
            margin-top: 0.5rem;
            display: none;
            z-index: 1001;
        }
        
        .dropdown-menu.show {
            display: block;
        }
        
        .dropdown-menu a {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem 1rem;
            color: var(--text-primary);
            text-decoration: none;
            transition: all 0.3s ease;
        }
        
        .dropdown-menu a:hover {
            background: var(--light-color);
            color: var(--primary-color);
        }
        
        .mobile-menu-toggle {
            display: none;
            background: rgba(255, 255, 255, 0.15);
            border: none;
            color: white;
            padding: 0.5rem;
            border-radius: 8px;
            cursor: pointer;
            font-size: 1.2rem;
        }
        
        @media (max-width: 768px) {
            .top-header {
                padding: 0 1rem;
                flex-wrap: wrap;
            }
            
            .nav-menu {
                display: none;
                position: absolute;
                top: 100%;
                left: 0;
                right: 0;
                background: white;
                box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
                flex-direction: column;
                padding: 1rem;
                gap: 0;
            }
            
            .nav-menu.show {
                display: flex;
            }
            
            .nav-menu a {
                color: var(--text-primary);
                padding: 1rem;
                border-radius: 8px;
                margin-bottom: 0.5rem;
            }
            
            .nav-menu a:hover,
            .nav-menu a.active {
                background: var(--primary-color);
                color: white;
                transform: none;
            }
            
            .mobile-menu-toggle {
                display: block;
            }
            
            .logo-container h4 {
                display: none;
            }
        }
        
        @media (max-width: 480px) {
            .top-header {
                padding: 0 0.5rem;
            }
            
            .logo-container img {
                width: 32px;
                height: 32px;
            }
        }
    </style>
</head>

<!-- Header Superior -->
<header class="top-header">
    <div class="logo-container">
        <img src="assets/logos/logo.svg" alt="Ecoterrenos" onerror="this.style.display='none'">
        <h4>Ecoterrenos</h4>
    </div>
    
    <nav class="nav-menu" id="navMenu">
        <a href="dashboard.php" class="<?php echo ($current_page == 'dashboard.php') ? 'active' : ''; ?>">
            <i class="fas fa-tachometer-alt"></i>
            Dashboard
        </a>
        <a href="contactos.php" class="<?php echo ($current_page == 'contactos.php') ? 'active' : ''; ?>">
            <i class="fas fa-address-book"></i>
            Contactos
        </a>
        <a href="importar_excel.php" class="<?php echo ($current_page == 'importar_excel.php') ? 'active' : ''; ?>">
            <i class="fas fa-file-excel"></i>
            Importar
        </a>
        <?php if (isset($_SESSION['user_type']) && $_SESSION['user_type'] === 'administrador'): ?>
        <a href="admin.php" class="<?php echo ($current_page == 'admin.php') ? 'active' : ''; ?>">
            <i class="fas fa-cog"></i>
            Admin
        </a>
        <?php endif; ?>
    </nav>
    
    <div class="user-dropdown">
        <button onclick="toggleDropdown()">
            <i class="fas fa-user-circle"></i>
            <?php echo htmlspecialchars($_SESSION['user_name'] ?? 'Usuario'); ?>
            <i class="fas fa-chevron-down"></i>
        </button>
        <div class="dropdown-menu" id="dropdownMenu">
            <a href="profile.php">
                <i class="fas fa-user"></i>
                Mi Perfil
            </a>
            <a href="logout.php">
                <i class="fas fa-sign-out-alt"></i>
                Cerrar Sesión
            </a>
        </div>
    </div>
    
    <button class="mobile-menu-toggle" onclick="toggleMobileMenu()">
        <i class="fas fa-bars"></i>
    </button>
</header>

<script>
    function toggleMobileMenu() {
        const navMenu = document.getElementById('navMenu');
        navMenu.classList.toggle('show');
    }
    
    function toggleDropdown() {
        const dropdown = document.getElementById('dropdownMenu');
        dropdown.classList.toggle('show');
    }
    
    // Close dropdown when clicking outside
    document.addEventListener('click', function(event) {
        const dropdown = document.getElementById('dropdownMenu');
        const userButton = document.querySelector('.user-dropdown button');
        
        if (!userButton.contains(event.target)) {
            dropdown.classList.remove('show');
        }
    });
    
    // Close mobile menu when clicking on links
    document.querySelectorAll('.nav-menu a').forEach(link => {
        link.addEventListener('click', () => {
            document.getElementById('navMenu').classList.remove('show');
        });
    });
    
    // Close mobile menu when resizing to desktop
    window.addEventListener('resize', () => {
        if (window.innerWidth > 768) {
            document.getElementById('navMenu').classList.remove('show');
        }
    });
</script>