<?php
// Test simple para verificar profile.php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "Iniciando prueba de profile.php...\n";

// Simular sesión de usuario
session_start();
$_SESSION['user_id'] = 1;
$_SESSION['user_name'] = 'test_user';
$_SESSION['user_type'] = 'usuario';

echo "Sesión simulada creada.\n";

// Incluir config.php
try {
    require_once 'config.php';
    echo "Config.php incluido correctamente.\n";
} catch (Exception $e) {
    echo "Error al incluir config.php: " . $e->getMessage() . "\n";
    exit;
}

// Verificar conexión PDO
if (isset($pdo) && $pdo instanceof PDO) {
    echo "Conexión PDO disponible.\n";
    
    // Probar una consulta simple
    try {
        $stmt = $pdo->prepare("SELECT COUNT(*) as total FROM usuarios");
        $stmt->execute();
        $result = $stmt->fetch();
        echo "Consulta de prueba exitosa. Total usuarios: " . $result['total'] . "\n";
    } catch (Exception $e) {
        echo "Error en consulta de prueba: " . $e->getMessage() . "\n";
    }
} else {
    echo "ERROR: Conexión PDO no disponible.\n";
}

echo "Prueba completada.\n";
?>